<x-app-layout>
    <x-slot name="header">
        Role
    </x-slot>

    <!-- Row -->
    <div class="row">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">
                        @isset($role->id)
                        Edit Role
                        @else
                        Add New Role
                        @endisset
                    </div>
                </div>
                <form action="
                    @isset($role->id)
                        {{ route('admin.role.update', $role->id) }}
                    @else
                        {{ route('admin.role.store') }}
                    @endisset
                    " method="post" enctype="multipart/form-data">
                    <div class="card-body">
                        @isset($role->id)
                        @method('PUT')
                        @endisset
                        @csrf
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="name">Role Name :</label>
                            <div class="">
                                <input type="search" class="form-control @error('name') is-invalid @enderror"
                                    name="name" value="{{ old('name', $role->name) }}" placeholder="Role Name">
                            </div>
                            @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <label class="custom-switch form-switch me-5">
                            <input type="checkbox" name="status" value="1" class="custom-switch-input" {{ old('status',
                                $role->status) == 1 ? 'checked' : '' }}>
                            <span class="custom-switch-indicator custom-switch-indicator-lg"></span>
                            <span class="custom-switch-description">Status</span>
                        </label>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Save</button>
                        <a href="{{route('admin.role.index')}}"
                            class="btn btn-default float-end">Discard</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Row -->
    <x-slot name="script">
        <script src="{{asset('backend/plugins/wysiwyag/jquery.richtext.js')}}"></script>
        <script src="{{asset('backend/plugins/wysiwyag/wysiwyag.js')}}"></script>
        <script>
            $(document).ready(function () {
            });
        </script>
    </x-slot>

</x-app-layout>
